<?php
require_once 'vendor/autoload.php';
include 'conexao.php';

use setasign\Fpdi\Fpdi;

// Função auxiliar para traduzir o mês
function traduz_mes($mes) {
    $meses = [
        'January' => 'Janeiro', 'February' => 'Fevereiro', 'March' => 'Março',
        'April' => 'Abril', 'May' => 'Maio', 'June' => 'Junho',
        'July' => 'Julho', 'August' => 'Agosto', 'September' => 'Setembro',
        'October' => 'Outubro', 'November' => 'Novembro', 'December' => 'Dezembro'
    ];
    return $meses[$mes] ?? $mes;
}

// ID do aluno
$aluno_id = $_GET['aluno_id'] ?? '';
$anoLectivo = $_GET['ano_lectivo'] ?? '2023/2024';

$pdf = new Fpdi();
$pdf->AddPage();
$pdf->setSourceFile('modelo_certificado.pdf');
$tpl = $pdf->importPage(1);
$pdf->useTemplate($tpl);
$pdf->SetFont('Times', '', 12);
$pdf->SetTextColor(0, 0, 0);

// Dados pessoais
$stmt = $conn->prepare("
    SELECT a.nome AS aluno, a.bi, a.nascimento, a.genero, c.nome AS curso,
           t.filiacao, t.naturalidade, t.provincia
    FROM alunos a
    LEFT JOIN cursos c ON a.curso_id = c.id
    LEFT JOIN termo t ON t.aluno_id = a.id
    WHERE a.id = ?
");
$stmt->bind_param('i', $aluno_id);
$stmt->execute();
$dados = $stmt->get_result()->fetch_assoc();

// Texto inicial fixo
$texto_inicial = "Eduardo Sanjambela Tchandja, Director do Complexo Escolar BG0026 Padre Emil Frick - Catumbela, certifica que, " .
    $dados['aluno'] . ", filha de " . $dados['filiacao'] . ", nascida aos " .
    date('d', strtotime($dados['nascimento'])) . " de " .
    traduz_mes(date('F', strtotime($dados['nascimento']))) . " de " .
    date('Y', strtotime($dados['nascimento'])) . ", no município de " .
    $dados['naturalidade'] . ", Província de " . $dados['provincia'] . ", portadora do B.I nº " .
    $dados['bi'] . ", passado pelo Arquivo de Identificação de Benguela aos 10 de Outubro de 2024.\n" .
    "Concluiu no ano lectivo $anoLectivo, o curso de " . $dados['curso'] . ", tendo obtido as seguintes classificações:";

$pdf->SetXY(25, 65);
$pdf->MultiCell(165, 7, utf8_decode($texto_inicial));

// Lista de disciplinas
$disciplinas_fixas = [
    'Língua Portuguesa', 'Inglês I', 'Matemática', 'Informática', 'Educação Física',
    'Filosofia', 'Inglês II', 'História', 'Geografia', 'Literatura', 'Sociologia', 'Empreendedorismo'
];

$pdf->SetFont('Times', 'B', 11);
$pdf->SetXY(25, 110);
$pdf->Cell(65, 8, utf8_decode("Disciplinas"), 1, 0, 'C');
$pdf->Cell(25, 8, utf8_decode("10ª Classe"), 1, 0, 'C');
$pdf->Cell(25, 8, utf8_decode("11ª Classe"), 1, 0, 'C');
$pdf->Cell(25, 8, utf8_decode("12ª Classe"), 1, 1, 'C');
$pdf->SetFont('Times', '', 11);

$y = 118;

foreach ($disciplinas_fixas as $disciplina) {
    // Buscar nota por classe
    $notas = ['10ª' => '', '11ª' => '', '12ª' => ''];
    $stmt = $conn->prepare("
        SELECT n.classe, n.nota_final
        FROM notas n
        JOIN disciplinas d ON n.disciplina_id = d.id
        WHERE n.aluno_id = ? AND d.nome = ?
    ");
    $stmt->bind_param("is", $aluno_id, $disciplina);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($linha = $res->fetch_assoc()) {
        $classe = $linha['classe'];
        if (in_array($classe, ['10ª', '11ª', '12ª'])) {
            $notas[$classe] = $linha['nota_final'];
        }
    }

    $pdf->SetXY(25, $y);
    $pdf->Cell(65, 8, utf8_decode($disciplina), 1);
    $pdf->Cell(25, 8, $notas['10ª'], 1, 0, 'C');
    $pdf->Cell(25, 8, $notas['11ª'], 1, 0, 'C');
    $pdf->Cell(25, 8, $notas['12ª'], 1, 1, 'C');

    $y += 8;
}

// Texto final com local e data
$pdf->SetXY(30, $y + 10);
$pdf->MultiCell(150, 7, utf8_decode("Complexo Escolar BG0026 Padre Emil Frick – Catumbela, aos " .
    date('d') . " de " . traduz_mes(date('F')) . " de " . date('Y') . "."), 0, 'L');

// Output
$pdf->Output('I', 'certificado.pdf');
